/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.world.cap;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.data.IWorldData;
import dev.toma.gunsrpg.api.common.data.IWorldEventSpec;
import dev.toma.gunsrpg.util.ModUtils;
import dev.toma.gunsrpg.world.cap.WorldDataProvider;
import dev.toma.gunsrpg.world.cap.events.AirdropEventHandler;
import dev.toma.gunsrpg.world.cap.events.BloodmoonEventHandler;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BooleanSupplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;

public class WorldData
implements IWorldData {
    private final World world;
    private final Set<IWorldEventSpec> events = new HashSet<IWorldEventSpec>();
    private final BooleanSupplier isBloodmoonSupplier;

    public WorldData() {
        this(null);
    }

    public WorldData(World world) {
        this.world = world;
        IWorldEventSpec bloodmoonEvent = IWorldEventSpec.of("bloodmoon", () -> GunsRPG.config.world.bloodmoonCycle, new BloodmoonEventHandler());
        this.addEvent(bloodmoonEvent);
        this.isBloodmoonSupplier = bloodmoonEvent::isEventActive;
        this.addEvent(IWorldEventSpec.of("airdrop", () -> GunsRPG.config.world.airdropFrequency, new AirdropEventHandler(world)));
    }

    public static IWorldData get(World world) {
        return (IWorldData)world.getCapability(WorldDataProvider.CAP, null).orElse(null);
    }

    public static boolean isBloodMoon(World world) {
        IWorldData cap = WorldData.get(world);
        return cap != null && cap.isBloodmoon();
    }

    @Override
    public boolean isBloodmoon() {
        return this.isBloodmoonSupplier.getAsBoolean();
    }

    @Override
    public void tick(World world) {
        long time = world.func_72820_D();
        long day = time / 24000L;
        this.events.forEach(spec -> spec.tick(world, day));
    }

    private void addEvent(IWorldEventSpec spec) {
        this.events.add(spec);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        for (IWorldEventSpec eventSpec : this.events) {
            nbt.func_218657_a(eventSpec.getEventName(), eventSpec.serializeNBT());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        for (IWorldEventSpec spec : this.events) {
            ModUtils.loadNBT(spec.getEventName(), spec, nbt);
        }
    }
}

